#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
Reprise des calculs planck Maple sous wet_03
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
--> C
-->
-->
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
--------------------------------------------------------------------------------
CONSIGNES :



--------------------------------------------------------------------------------
"""

# ------------------------------------------------------------------------------
# Initialisation des librairies qui contiennent les fonctions usuelles
# ------------------------------------------------------------------------------
import matplotlib.pyplot as plt
import numpy as np
from math import exp, expm1
from tkinter import *
from tkinter.font import Font
#fen1=Tk()
#tex1=Label(fen1,text='Bonjour tout le monde !',fg='red')
#tex1.pack()
#bou1=Button(fen1,text='Quitter',command=fen1.destroy)
#bou1.pack()
#fen1.mainloop()
print("Entrez le numero du fichier de commande\n")
prefixe="ficcom_v0001_"
numfic_com=input("Entrez le numero du fichier de commande :")
nomfic_com=prefixe+numfic_com+".txt"
print(nomfic_com)
infic_01=open(nomfic_com,'r')
logfic=open("ficlog.txt","w")        # compte rendu d'exécution
buf=infic_01.readline()
logfic.write(buf)
nom_appli_01=infic_01.read(30)
nom_appli=nom_appli_01.strip()  # retire les blancs
logfic.write(nom_appli)
buf=infic_01.readline()
logfic.write(buf)
nom_abso_atmo=infic_01.read(30)
nom_abso_atmo=nom_abso_atmo.strip()  # retire les blancs
logfic.write(nom_abso_atmo)
buf=infic_01.readline()
logfic.write(buf)
nom_refl_atmo=infic_01.read(30)
nom_refl_atmo=nom_refl_atmo.strip()  # retire les blancs
logfic.write(nom_refl_atmo)
buf=infic_01.readline()
logfic.write(buf)
nom_refl_terre=infic_01.read(30)
nom_refl_terre=nom_refl_terre.strip()  # retire les blancs
logfic.write(nom_refl_atmo)
buf=infic_01.readline()
logfic.write(buf)
Tempe_soleil=float(infic_01.read(30))
logfic.write(str(Tempe_soleil))
buf=infic_01.readline()
logfic.write(buf)
puiss_soleil=float(infic_01.read(30))  # puissance incidente en W/m^2
logfic.write(str(puiss_soleil))
buf=infic_01.readline()
logfic.write(buf)
fact_reduc=float(infic_01.read(30))  # puissance incidente en W/m^2
logfic.write(str(fact_reduc))
buf=infic_01.readline()
logfic.write(buf)

nbpts=int(infic_01.read(30))  # nombre de points en longueur d'onde
logfic.write(str(nbpts))
buf=infic_01.readline()
logfic.write(buf)
lamax=float(infic_01.read(30))  # longueur d'onde maxi pour les calculs
logfic.write(str(lamax))
buf=infic_01.readline()
logfic.write(buf)
refl_max=float(infic_01.read(30))  # coef de réflexion maximal (refl multiples)
logfic.write(str(refl_max))
buf=infic_01.readline()
logfic.write(buf)
kelvin=float(infic_01.read(30))  # coef de réflexion maximal (refl multiples)
logfic.write(str(kelvin))
buf=infic_01.readline()
logfic.write(buf)
masse_atmo=float(infic_01.read(30))  # masse d'air au dessus d'1 m2
logfic.write(str(masse_atmo))
buf=infic_01.readline()
logfic.write(buf)
cap_ther_atmo=float(infic_01.read(30))  # chaleur massique de l'air
logfic.write(str(cap_ther_atmo))
buf=infic_01.readline()
logfic.write(buf)
masse_terre=float(infic_01.read(30))  # masse volumique de la terre
logfic.write(str(masse_terre))
buf=infic_01.readline()
logfic.write(buf)
cap_ther_terre=float(infic_01.read(30))  # chaleur massique de la terre
logfic.write(str(cap_ther_terre))
buf=infic_01.readline()
logfic.write(buf)
tempe_init_atmo=float(infic_01.read(30))  # Température initiale de l'atmosphère
logfic.write(str(tempe_init_atmo))
buf=infic_01.readline()
logfic.write(buf)
tempe_init_sol=float(infic_01.read(30))  # Température initiale du sol
logfic.write(str(tempe_init_sol))
buf=infic_01.readline()
logfic.write(buf)
nb_pas_de_temps=int(infic_01.read(30))  # nombre de pas de temps pour l'évolution thermique
logfic.write(str(nb_pas_de_temps))
buf=infic_01.readline()
logfic.write(buf)
duree_pas_de_temps=float(infic_01.read(30))  # durée d'un pas de temps en seconde
logfic.write(str(duree_pas_de_temps))
buf=infic_01.readline()
logfic.write(buf)
puiss_sol=float(infic_01.read(30))  # puissance générée dans le sous-sol
logfic.write(str(puiss_sol))
buf=infic_01.readline()
logfic.write(buf)
courbes=int(infic_01.read(30))  # code pour les courbes à tracer
logfic.write(str(courbes))
buf=infic_01.readline()
logfic.write(buf)

logfic.close()

infic_01.close()

infic_abso_atmo=open(nom_abso_atmo,'r')
infic_refl_atmo=open(nom_refl_atmo,'r')
infic_refl_terre=open(nom_refl_terre,'r')
la_abso_atmo_lu=[]
abso_atmo_lu=[]
la_refl_atmo_lu=[]
refl_atmo_lu=[]
la_refl_terre_lu=[]
refl_terre_lu=[]
buf=infic_abso_atmo.readline()
while 1:
    buf=infic_abso_atmo.read(25)
  #  print(buf)
    if buf=="":
        break
    var_float=float(buf.strip())
    la_abso_atmo_lu.append(var_float)
    var_float=float(infic_abso_atmo.readline().strip())
    abso_atmo_lu.append(var_float)
infic_abso_atmo.close()

buf=infic_refl_atmo.readline()
while 1:
    buf=infic_refl_atmo.read(25)
    if buf=="":
        break
    var_float=float(buf.strip())
    la_refl_atmo_lu.append(var_float)
    var_float=float(infic_refl_atmo.readline().strip())
    refl_atmo_lu.append(var_float)
infic_refl_atmo.close()

buf=infic_refl_terre.readline()
while 1:
    buf=infic_refl_terre.read(25)
    if buf=="":
        break
    var_float=float(buf.strip())
    la_refl_terre_lu.append(var_float)
    var_float=float(infic_refl_terre.readline().strip())
    refl_terre_lu.append(var_float)
infic_refl_terre.close()

# interpolation aux point de calculs
delta_la=lamax/(nbpts-1)

abso_atmo=[]
lam=0                      # longueur d'onde
i=0
while i<nbpts :
    while (lam<=la_abso_atmo_lu[0])&(i<nbpts) :
        abso_atmo.append(abso_atmo_lu[0])
        i=i+1
        lam=delta_la*i
    n1=len(abso_atmo_lu)
    i0=0
    while (i0<n1-1)&(i<nbpts):
        while (lam<la_abso_atmo_lu[i0+1])&(i<nbpts):
            var_float=(abso_atmo_lu[i0+1]-abso_atmo_lu[i0])/(la_abso_atmo_lu[i0+1]-la_abso_atmo_lu[i0])*(lam-la_abso_atmo_lu[i0])+abso_atmo_lu[i0]
            abso_atmo.append(var_float)
            i=i+1
            lam=delta_la*i
        i0=i0+1
    while (lam>=la_abso_atmo_lu[n1-1])&(i<nbpts):
        abso_atmo.append(abso_atmo_lu[n1-1])
        i=i+1
        lam=delta_la*i
# la liste abso_atmo est remplie et contient nbpts valeurs

refl_atmo=[]
lam=0                      # longueur d'onde
i=0
while i<nbpts :
    while (lam<=la_refl_atmo_lu[0])&(i<nbpts) :
        refl_atmo.append(refl_atmo_lu[0])
        i=i+1
        lam=delta_la*i
    n1=len(refl_atmo_lu)
    i0=0
    while (i0<n1-1)&(i<nbpts):
        while (lam<la_refl_atmo_lu[i0+1])&(i<nbpts):
            var_float=(refl_atmo_lu[i0+1]-refl_atmo_lu[i0])/(la_refl_atmo_lu[i0+1]-la_refl_atmo_lu[i0])*(lam-la_refl_atmo_lu[i0])+refl_atmo_lu[i0]
            refl_atmo.append(var_float)
            i=i+1
            lam=delta_la*i
        i0=i0+1
    while (lam>=la_refl_atmo_lu[n1-1])&(i<nbpts):
        refl_atmo.append(refl_atmo_lu[n1-1])
        i=i+1
        lam=delta_la*i
# la liste refl_atmo est remplie et contient nbpts valeurs

refl_terre=[]
lam=0                      # longueur d'onde
i=0
while i<nbpts :
    while (lam<=la_refl_terre_lu[0])&(i<nbpts) :
        refl_terre.append(refl_terre_lu[0])
        i=i+1
        lam=delta_la*i
    n1=len(refl_terre_lu)
    i0=0
    while (i0<n1-1)&(i<nbpts):
        while (lam<la_refl_terre_lu[i0+1])&(i<nbpts):
            var_float=(refl_terre_lu[i0+1]-refl_terre_lu[i0])/(la_refl_terre_lu[i0+1]-la_refl_terre_lu[i0])*(lam-la_refl_terre_lu[i0])+refl_terre_lu[i0]
            refl_terre.append(var_float)
            i=i+1
            lam=delta_la*i
        i0=i0+1
    while (lam>=la_refl_terre_lu[n1-1])&(i<nbpts):
        refl_terre.append(refl_terre_lu[n1-1])
        i=i+1
        lam=delta_la*i
# la liste refl_terre est remplie et contient nbpts valeurs
# controle de la cohérence des données : abso_atmo + refl_atmo <= 1 et refl_atmo < refl_max
trans_atmo=[]
for i in range(0,nbpts):
    if refl_atmo[i]>refl_max:
        refl_atmo[i]=refl_max
    if abso_atmo[i]>1:
        abso_atmo[i]=1
    if abso_atmo[i]+refl_atmo[i]>1:
        refl_atmo[i]=1-abso_atmo[i]
    trans_atmo.append(1-refl_atmo[i]-abso_atmo[i])
# idem pour la Terre :
abso_terre=[]
for i in range(0,nbpts):
    if refl_terre[i]>refl_max:
        refl_terre[i]=refl_max
    abso_terre.append(1-refl_terre[i])
    if abso_terre[i]>1:
        abso_terre[i]=1
    if abso_terre[i]+refl_terre[i]>1:
        refl_terre[i]=1-abso_terre[i]
# conventions :
    # P1 = puissance spectrale incidente du Soleil en W/m2
    # P2 = puissance spectrale absorbée depuis le Soleil par l'atmosphère
    # P3 = puissance spectrale réfléchie vers l'espace
    # P4 = puissance spectrale rayonnée par l'atmosphère vers l'espace
    # P5 = puissance spectrale rayonnée par l'atmosphère vers la Terre
    # P6_tot = puissance spectrale réfléchie par l'atmosphère vers la Terre en tenant compte des réflexions multiples
    # P9 = puissance spectrale transmise depuis la Terre à travers l'atmosphère vers l'espace
    # P10 = puissance spectrale rayonnée par la Terre
    # P11_tot = puissance spectrale réfléchie par la Terre vers l'atmosphère
    # P12 = puissance spectrale du rayonnement solaire transmis à travers l'atmosphère vers la Terre
    # P13 = puissance générée dans le sous-sol
    # P14 = puissance spectrale absorbée par la Terre

    # Tempe_atm = température en Kelvin de l'atmosphère
    # Tempe_terre= = température en Kelvin de la terre
    # Tempe_soleil = température en kelvin du Soleil
    # kelvin = 273.15

# définition des constantes physiques pour planck :

c=299792458.0            # vitesse de la lumière (ms^-1)
h=6.6260687652*10**(-34)    # constante de Planck (Js)
k=1.380650324*10**(-23)     # constante de Boltzmann (JK^-1)
Pi=3.141592654
sigma_stef=5.670374*10**(-8)
couleur=['#FF8000','#9443e3','#4366e3','#43e396','#b8533a','#5e966a','#FF0000','#00FF00','#0000FF','#000000','#888888','#FFFF00']   #cb3c2e = C0

lamin_trac=0.0          # longueur d'onde minimale pour le tracé en micromètre
lamax_trac=1000.0         # longueur d'onde maximale pour le tracé en micromètre

# Conversion des températures en Kelvin

def planck_fonc(Tempe,la):       # calcul de la fonction de Planck
 #   return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(h*c/(la*10**(-6)*k*Tk[i]))-1))
    if la>10**(-200) :
       x=h*c/(la*10**(-6)*k*Tempe)
       if x<700 :
           return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(x)))  # exp(x)-1
       else:
            return 0
    else:
        return 0
def planck_wien_fonc(la):    # ligne des maxima
 #   return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(h*c/(la*10**(-6)*k*(2898.0/la)))-1))
    if la>10**(-200):
        x=h*c/(la*10**(-6)*k*(2898.0/la))
        if x<700 :
            return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(x)))
        else :
            return 0
    else:
        return 0
puiss_t4=sigma_stef*Tempe_soleil*Tempe_soleil*Tempe_soleil*Tempe_soleil
rapport=puiss_soleil/puiss_t4  # du à l'éloignement du Soleil
rapport=rapport*fact_reduc
planck_soleil=[]
la_var=[]
for ii in range(0,nbpts):
    la_var.append(delta_la*ii)
for ii in range(0,nbpts):
    planck_soleil.append(planck_fonc(Tempe_soleil,la_var[ii])*rapport)
#Tempe_atm=tempe_init_atmo+kelvin
#Tempe_terre=tempe_init_sol+kelvin
resu_tempe_terre=[]
resu_tempe_atmo=[]

temps=[]
temps.append(0)
resu_tempe_terre.append(tempe_init_sol+kelvin)
resu_tempe_atmo.append(tempe_init_atmo+kelvin)
resu_tempe_atm_celsius=[]
resu_tempe_ter_celsius=[]
temps_heure=[]
resu_tempe_atm_celsius.append(tempe_init_atmo)
resu_tempe_ter_celsius.append(tempe_init_sol)
resu_P1=[]
resu_P2=[]
resu_P3=[]
resu_P4=[]
resu_P5=[]
resu_P6=[]
resu_P8=[]
resu_P9=[]
resu_P10=[]
resu_P11=[]
resu_P12=[]
resu_P13=[]
resu_P14=[]
P13=puiss_sol
temps_heure.append(0)

for itemps in range(0,nb_pas_de_temps):
    print(itemps)
    delta_Ta=0
    delta_Tt=0
    P1=[]
    P2=[]
    P3=[]
    P4=[]
    P5=[]
    P6_tot=[]
    P8=[]
    P9=[]
    P10=[]
    P11_tot=[]
    P12=[]
    P14=[]
    dTa=[]
    dTt=[]
    P1_int=0
    P2_int=0
    P3_int=0
    P4_int=0
    P5_int=0
    P6_int=0
    P8_int=0
    P9_int=0
    P10_int=0
    P11_int=0
    P12_int=0
    P14_int=0


    for ii in range(0,nbpts):
        P1.append(planck_soleil[ii])
        P2.append(P1[ii]*abso_atmo[ii])
        P3.append(P1[ii]*refl_atmo[ii])
        P4.append(planck_fonc(resu_tempe_atmo[itemps],la_var[ii])*abso_atmo[ii])
        P5.append(P4[ii])
        P10.append(planck_fonc(resu_tempe_terre[itemps],la_var[ii])*abso_terre[ii])
        P12.append(P1[ii]*trans_atmo[ii])
        P11_tot.append((P10[ii]+(P12[ii]+P5[ii])*refl_terre[ii])/(1-refl_atmo[ii]*refl_terre[ii]))  # réflexions multiples
        P6_tot.append(P11_tot[ii]*refl_atmo[ii])
        P8.append(P11_tot[ii]*abso_atmo[ii])
        P14.append((P12[ii]+P5[ii]+P6_tot[ii])*abso_terre[ii])
        dTa.append(((P1[ii]+P11_tot[ii])*abso_atmo[ii]-P5[ii]-P4[ii])*duree_pas_de_temps/cap_ther_atmo/masse_atmo)
        dTt.append(((P12[ii]+P5[ii]+P6_tot[ii])*abso_terre[ii]-P10[ii])*duree_pas_de_temps/cap_ther_terre/masse_terre)
        delta_Ta=delta_Ta+dTa[ii]
        delta_Tt=delta_Tt+dTt[ii]
        P1_int=P1_int+P1[ii]
        P2_int=P2_int+P2[ii]
        P3_int=P3_int+P3[ii]
        P4_int=P4_int+P4[ii]
        P5_int=P5_int+P5[ii]
        P6_int=P6_int+P6_tot[ii]
        P8_int=P8_int+P8[ii]
        P9_int=P9_int+P11_tot[ii]*trans_atmo[ii]
        P10_int=P10_int+P10[ii]
        P11_int=P11_int+P11_tot[ii]
        P12_int=P12_int+P12[ii]
        P14_int=P14_int+P14[ii]
    delta_Ta*=delta_la*10**(-6)
    delta_Tt*=delta_la*10**(-6)
    P1_int*=delta_la*10**(-6)
    P2_int*=delta_la*10**(-6)
    P3_int*=delta_la*10**(-6)
    P4_int*=delta_la*10**(-6)
    P5_int*=delta_la*10**(-6)
    P6_int*=delta_la*10**(-6)
    P8_int*=delta_la*10**(-6)
    P9_int*=delta_la*10**(-6)
    P10_int*=delta_la*10**(-6)
    P11_int*=delta_la*10**(-6)
    P12_int*=delta_la*10**(-6)
    P14_int*=delta_la*10**(-6)
    resu_P1.append(P1_int)
    resu_P2.append(P2_int)
    resu_P3.append(P3_int)
    resu_P4.append(P4_int)
    resu_P5.append(P5_int)
    resu_P6.append(P6_int)
    resu_P8.append(P8_int)
    resu_P9.append(P9_int)
    resu_P10.append(P10_int)
    resu_P11.append(P11_int)
    resu_P12.append(P12_int)
    resu_P13.append(P13)
    resu_P14.append(P14_int)

    if courbes==1:
        plt.clf()
        plt.axis([0,20,0,int(max(max(P1),max(P2),max(P3),max(P4),max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot),max(P12),max(P14)))])

        plt.plot(la_var,P1,couleur[0], label = "P1")
        plt.plot(la_var,P2,couleur[1], label = "P2")
        plt.plot(la_var,P3,couleur[2], label = "P3")
        plt.plot(la_var,P4,couleur[3], label = "P4")
        plt.plot(la_var,P5,couleur[4], label = "P5")
        plt.plot(la_var,P6_tot,couleur[5], label = "P6_tot")
        plt.plot(la_var,P8,couleur[6], label = "P8")
        plt.plot(la_var,P10,couleur[7], label = "P10")
        plt.plot(la_var,P11_tot,couleur[8], label = "P11_tot")
        plt.plot(la_var,P12,couleur[9], label = "P12")
        plt.plot(la_var,P14,couleur[10], label = "P14")


        plt.grid()
        plt.xlabel("Longueur d'onde en micromètres")
        plt.ylabel("Puissance spectrale")

        #   Titre du graphe
        plt.title("Effet de serre")

        #   Affichage des noms des courbes et du graphe
        plt.legend()
        plt.show()

    if courbes==2:
        plt.clf()
     #   plt.axis([0,20,0,int(max(max(P1),max(P2),max(P3),max(P4),max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot),max(P12),max(P14)))])
        plt.axis([0,10,0,int(max(max(P1),max(P2),max(P3),max(P4),max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot),max(P12),max(P14)))])

        plt.plot(la_var,P1,couleur[0], label = "P1")
        plt.plot(la_var,P2,couleur[1], label = "P2")
        plt.plot(la_var,P3,couleur[2], label = "P3")
    #    plt.plot(la_var,P4,couleur[3], label = "P4")
    #    plt.plot(la_var,P5,couleur[4], label = "P5")
    #    plt.plot(la_var,P6_tot,couleur[5], label = "P6_tot")
   #     plt.plot(la_var,P8,couleur[6], label = "P8")
        plt.plot(la_var,P10,couleur[7], label = "P10")
    #    plt.plot(la_var,P11_tot,couleur[8], label = "P11_tot")
        plt.plot(la_var,P12,couleur[9], label = "P12")
        plt.plot(la_var,P14,couleur[10], label = "P14")


        plt.grid()
        plt.xlabel("Longueur d'onde en micromètres")
        plt.ylabel("Puissance spectrale")

        #   Titre du graphe
        plt.title("Effet de serre")

        #   Affichage des noms des courbes et du graphe
        plt.legend()
        plt.show()

    if courbes==3:
        plt.clf()
     #   plt.axis([0,20,0,int(max(max(P1),max(P2),max(P3),max(P4),max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot),max(P12),max(P14)))])
        plt.axis([0,20,0,int(max(max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot)))])

      #  plt.plot(la_var,P1,couleur[0], label = "P1")
     #   plt.plot(la_var,P2,couleur[1], label = "P2")
     #   plt.plot(la_var,P3,couleur[2], label = "P3")
    #    plt.plot(la_var,P4,couleur[3], label = "P4")
        plt.plot(la_var,P5,couleur[4], label = "P5")
        plt.plot(la_var,P6_tot,couleur[5], label = "P6_tot")
        plt.plot(la_var,P8,couleur[6], label = "P8")
        plt.plot(la_var,P10,couleur[7], label = "P10")
        plt.plot(la_var,P11_tot,couleur[8], label = "P11_tot")
    #    plt.plot(la_var,P12,couleur[9], label = "P12")
     #   plt.plot(la_var,P14,couleur[10], label = "P14")


        plt.grid()
        plt.xlabel("Longueur d'onde en micromètres")
        plt.ylabel("Puissance spectrale")

        #   Titre du graphe
        plt.title("Effet de serre")

        #   Affichage des noms des courbes et du graphe
        plt.legend()
        plt.show()
    if (courbes==4)&(itemps==0):
        plt.clf()
     #   plt.axis([0,20,0,int(max(max(P1),max(P2),max(P3),max(P4),max(P5),max(P6_tot),max(P8),max(P10),max(P11_tot),max(P12),max(P14)))])
        plt.axis([0,20,0,1])

      #  plt.plot(la_var,P1,couleur[0], label = "P1")
     #   plt.plot(la_var,P2,couleur[1], label = "P2")
     #   plt.plot(la_var,P3,couleur[2], label = "P3")
    #    plt.plot(la_var,P4,couleur[3], label = "P4")
        plt.plot(la_var,abso_atmo,couleur[0], label = "Absorption de l'atmosphère")
        plt.plot(la_var,refl_atmo,couleur[1], label = "Réflexion de l'atmosphère")
        plt.plot(la_var,trans_atmo,couleur[8], label = "Transmission de l'atmosphère")
        plt.plot(la_var,abso_terre,couleur[9], label = "Absorption du sol")
        plt.plot(la_var,refl_terre,couleur[10], label = "Réflexion du sol")
      #  plt.plot(la_var,P12,couleur[9], label = "P12")
       # plt.plot(la_var,P14,couleur[10], label = "P14")


        plt.grid()
        plt.xlabel("Longueur d'onde en micromètres")
        plt.ylabel("Coefficients")

        #   Titre du graphe
        plt.title("Effet de serre")

        #   Affichage des noms des courbes et du graphe
        plt.legend()
        plt.show()

    delta_Tt=delta_Tt+P13*duree_pas_de_temps/cap_ther_terre/masse_terre
    buf=resu_tempe_atmo[itemps]+delta_Ta
    if buf<10 :
        buf=10
    resu_tempe_atmo.append(buf)
    buf=resu_tempe_terre[itemps]+delta_Tt
    if buf<10:
        buf=10
    resu_tempe_terre.append(buf)
    temps.append(temps[itemps]+duree_pas_de_temps)
    temps_heure.append(temps[itemps]/3600.0)
    resu_tempe_atm_celsius.append(resu_tempe_atmo[itemps]-kelvin)
    resu_tempe_ter_celsius.append(resu_tempe_terre[itemps]-kelvin)
# pour compléter laliste des puissances
resu_P1.append(P1_int)
resu_P2.append(P2_int)
resu_P3.append(P3_int)
resu_P4.append(P4_int)
resu_P5.append(P5_int)
resu_P6.append(P6_int)
resu_P8.append(P8_int)
resu_P9.append(P9_int)
resu_P10.append(P10_int)
resu_P11.append(P11_int)
resu_P12.append(P12_int)
resu_P13.append(P13)
resu_P14.append(P14_int)


print("Température finale de la Terre : "+str(resu_tempe_ter_celsius[len(resu_tempe_ter_celsius)-1])+' °C')
print("Temérature finale de l'atmosphère : "+str(resu_tempe_atm_celsius[len(resu_tempe_atm_celsius)-1])+' °C')
fen1=Tk()
can1=Canvas(fen1,bg='white',height=500,width=1000)
can1.pack(side=LEFT)
#bou1=Button(fen1,text='Quitter pour la suite', command=fen1.quit)
#bou1.pack(side=TOP)
can1.create_rectangle(0,100,1000,200,fill='#59cded', outline='#59cded')
can1.create_rectangle(0,400,1000,500,fill='#a1652e', outline='#a1652e')

#from tkinter.font import Font


font = Font(family='Arial', size=12)

texte = 'La température de l\'atmosphère est '+str(resu_tempe_atm_celsius[len(resu_tempe_atm_celsius)-1])[0:7]+' °C'
y_texte = 150
x_texte = 220
can1.create_text(x_texte, y_texte, text=texte, font=font, fill='#000080' )    # anchor='w'
texte = 'La température de la Terre est '+str(resu_tempe_ter_celsius[len(resu_tempe_ter_celsius)-1])[0:7]+' °C'
can1.create_text(200,450,text=texte,font=font,fill='#ecc49f')

onde_bleue=PhotoImage(file='onde_bleue_05_90px.png')
item=can1.create_image(50,50,image=onde_bleue)
texte='Rayonnement solaire incident\nP1 = '+str(resu_P1[len(resu_P1)-1])[0:7]+' W/m^2'
can1.create_text(170,50,text=texte,font=font,fill='#110e90')

item=can1.create_image(50,250,image=onde_bleue)
texte='Rayonnement solaire transmis\nP12 = '+str(resu_P12[len(resu_P12)-1])[0:7]+' W/m^2'
can1.create_text(170,250,text=texte,font=font,fill='#110e90')

onde_rouge_haut=PhotoImage(file='onde_rouge_05_90px_180.png')
item=can1.create_image(350,350,image=onde_rouge_haut)
texte='Rayonnement terrestre émis\nP10 = '+str(resu_P10[len(resu_P10)-1])[0:7]+' W/m^2'
can1.create_text(465,350,text=texte,font=font,fill='#af1919')

onde_rouge_bas=PhotoImage(file='onde_rouge_05_90px.png')
item=can1.create_image(350,250,image=onde_rouge_bas)
texte='Rayonnement atmosphérique émis\nP5 = '+str(resu_P5[len(resu_P5)-1])[0:7]+' W/m^2'
can1.create_text(485,250,text=texte,font=font,fill='#af1919')

item=can1.create_image(350,50,image=onde_rouge_haut)
texte='Rayonnement atmosphérique émis\nP4 = '+str(resu_P4[len(resu_P4)-1])[0:7]+' W/m^2'
can1.create_text(485,50,text=texte,font=font,fill='#af1919')

onde_verte_haut=PhotoImage(file='onde_verte_05_45_haut_90px.png')
item=can1.create_image(630,300,image=onde_verte_haut)
texte='Rayonnement réfléchi\nP11 = '+str(resu_P11[len(resu_P11)-1])[0:7]+' W/m^2'
can1.create_text(720,330,text=texte,font=font,fill='#0d7618')

onde_verte_bas=PhotoImage(file='onde_verte_05_45_bas_90px.png')
item=can1.create_image(830,300,image=onde_verte_bas)
texte='Rayonnement réfléchi\nP6 = '+str(resu_P6[len(resu_P6)-1])[0:7]+' W/m^2'
can1.create_text(905,270,text=texte,font=font,fill='#0d7618')

item=can1.create_image(630,50,image=onde_verte_haut)
texte='Rayonnement réfléchi\nP3 = '+str(resu_P3[len(resu_P3)-1])[0:7]+' W/m^2'
can1.create_text(720,80,text=texte,font=font,fill='#0d7618')

item=can1.create_image(730,150,image=onde_rouge_haut)
texte='Rayonnement terrestre transmis\nP9 = '+str(resu_P9[len(resu_P9)-1])[0:7]+' W/m^2'
can1.create_text(860,150,text=texte,font=font,fill='#af1919')


fen1.mainloop()
#fen1.destroy()




plt.clf()
plt.axis([0,temps_heure[len(temps_heure)-1],int(min(min(resu_tempe_atm_celsius),min(resu_tempe_ter_celsius)))-1,5+int(max(max(resu_tempe_atm_celsius),max(resu_tempe_ter_celsius)))])

plt.plot(temps_heure,resu_tempe_atm_celsius,couleur[0], label = "Temperature atmosphère °C")
plt.plot(temps_heure,resu_tempe_ter_celsius,couleur[1], label = "Temperature sol °C")
plt.grid()
plt.xlabel("Temps en heure")
plt.ylabel("Température")

#   Titre du graphe
plt.title("Effet de serre")

#   Affichage des noms des courbes et du graphe
plt.legend()
plt.show()

plt.clf()
plt.axis([0,temps_heure[len(temps_heure)-1],int(min(min(resu_P1),min(resu_P2),min(resu_P3),min(resu_P4),min(resu_P6),min(resu_P8),min(resu_P9),min(resu_P10),min(resu_P11),min(resu_P12),min(resu_P13),min(resu_P14)))-50,int(max(max(resu_P1),max(resu_P2),max(resu_P3),max(resu_P4),max(resu_P6),max(resu_P8),max(resu_P9),max(resu_P10),max(resu_P11),max(resu_P12),max(resu_P13),max(resu_P14)))+100])

plt.plot(temps_heure,resu_P1,couleur[0], label = "P1 incident W/m^2")
plt.plot(temps_heure,resu_P2,couleur[1], label = "P2 abso Soleil atm W/m^2")
plt.plot(temps_heure,resu_P3,couleur[2], label = "P3 reflec esp W/m^2")
plt.plot(temps_heure,resu_P4,couleur[3], label = "P4 rayon esp W/m^2")
plt.plot(temps_heure,resu_P6,couleur[11], label = "P6 reflect vers Terre W/m^2")
plt.plot(temps_heure,resu_P8,couleur[5], label = "P8 abso Terre atm W/m^2")
plt.plot(temps_heure,resu_P9,couleur[6], label = "P9 trans Terre esp W/m^2")
plt.plot(temps_heure,resu_P10,couleur[7], label = "P10 rayon Terre W/m^2")
plt.plot(temps_heure,resu_P11,couleur[8], label = "P11 reflect Terre vers atm W/m^2")
plt.plot(temps_heure,resu_P12,couleur[9], label = "P12 trans Soleil vers Terre W/m^2")
plt.plot(temps_heure,resu_P13,couleur[10], label = "P13 généré Terre W/m^2")
plt.plot(temps_heure,resu_P14,couleur[4], label = "P14 abso Terre W/m^2")
plt.grid()
plt.xlabel("Temps en heure")
plt.ylabel("Puissance W/m^2")

#   Titre du graphe
plt.title("Effet de serre")

#   Affichage des noms des courbes et du graphe
plt.legend()
plt.show()


